# -*- coding: utf-8 -*-
"""
Created on Mon Aug 24 20:07:59 2020

@author: Swapnil Keshari
"""
import math
B=0.340 #0.254
C=0.460 #0.3556
D=0.025#0.402
#Dh=0.4#0.3048
do=0.03#0.5
#p=0.045#0.019
#Nre_shell=833.0
#ho=190.0
#Nre_tube=36383.0
#hio=3093.0
kc=14.0#14.627
Rt=8.2*(0.0001)
Ra=8.2*(0.0001)
TinB=127.0#150
TinA=30.0#25
ToutB=100.0#170
ToutA=47.0#85
M_B=1350.0
M_A=2141.0
#Dh2=0.43#0.2921
#Dh1=0.37#0.3175
Cp_B=1.0#1.1
Cp_A=1.0#1
mu_B=1.89#0.504*!0
mu_A=5.76#0.255*10
rho_B= 870.0#950.6
rho_A= 935.0#985.2
k_B=0.419#0.682
k_A=0.4075#0.649
#r=0.2#0.1524

Dh=(B+C)/2
Dh1=Dh-do
Dh2=Dh+do
p=1.5*do
r=Dh/2


pi=math.pi
L_N=math.sqrt((4*pi*pi*r*r + p*p))
#L_N=1.257
#L=N*math.sqrt((2*pi*r*r + p*p))
#L=1.257*N
V_coil= (pi/4)*do*do*L_N #divided by N (for 1 turn)
V_annulus= (pi/4)*(C*C-B*B)*p #divided by N (for 1 turn)
V_flow=V_annulus-V_coil #divided by N (for 1 turn)
D_eqv=4*V_flow/(pi*do*L_N)

A_a =pi*((C**2-B**2)-(Dh2**2-Dh1**2))/4
u_a=M_A/(rho_A*A_a)
Nre_shell = D_eqv*u_a*rho_A/mu_A
Npr_shell = (Cp_A*mu_A/k_A)

A_f = pi*D*D/4.0
u_f = M_B/(rho_B*A_f)
Nre_tube = D*u_f*rho_B/mu_B
Npr_tube = (Cp_B*mu_B/k_B)

#assumung mu/mu_w =1
if Nre_shell < 10000:
    ho = 0.6*(Nre_shell**0.5)*((Npr_shell)**(0.31))*(k_A/D_eqv)
else:
    #change it after seeing mu_w
    #j_h=0.023*((Nre_shell)**(-0.2))
    ho= 0.36*(Nre_shell**0.55)*(Npr_shell**(1.0/3.0))*(k_A/D_eqv)

if Nre_tube < 10000:
    hio = 0.6*(Nre_tube**0.5)*((Npr_tube)**(0.31))*(k_B/do)
else:
    #j_h=0.023*((Nre_tube)**(-0.2))
    #j_h=110.0
    hi= 0.027*(Nre_tube**0.8)*(Npr_tube**(1.0/3.0))*(k_B/do)
    hic= hi*(1+3.5*(D/Dh))

x=(do-D)/2

U=1/(1/ho+1/hic+x*(1/kc)+Rt+Ra)

delta_t_lm=((TinA-TinB)-(ToutA-ToutB))/math.log((TinA-TinB)/(ToutA-ToutB))
delta_t_c=0.99*delta_t_lm

Q=M_A*Cp_A*(TinA-ToutA)
A=Q/(U*delta_t_c)

N= A/(pi*do*L_N)

H = math.ceil(N)*p +do


